using System;
using Server;
using Server.Items;
using Server.Mobiles;
using Xanthos.Interfaces;

namespace Xanthos.Evo
{
	//[CorpseName( "a guardian hiryu corpse" )]
	public class GuardianHiryu : EvoHiryu, IEvoGuardian
	{
		public override bool AddPointsOnDamage { get { return false; } }
		public override bool AddPointsOnMelee { get { return false; } }

		[Constructable]
		public GuardianHiryu() : base( "A Guardian Hiryu" )
		{
		}

		public GuardianHiryu( Serial serial ) : base( serial )
		{
		}

		protected override void Init()
		{
			base.Init();			// Create and fully evolve the creature

			// Buff it up
// 			SetStr( Str * 3 );
// 			SetDex( Dex * 3 );
// 			SetStam( Stam * 3 );
// 			SetInt( (int)(Int * 2) );
// 			SetMana( (int)(Mana * 2) );
			BaseEvoSpec spec = GetEvoSpec();
			SetResistance( ResistanceType.Physical, 65, 75 );
			SetResistance( ResistanceType.Fire, 80, 90 );
			SetResistance( ResistanceType.Cold, 70, 80 );
			SetResistance( ResistanceType.Poison, 60, 70 );
			SetResistance( ResistanceType.Energy, 60, 70 );
			
			SetStr( 190, 200 );
			SetDex( 51, 60 );
			SetInt( 91, 100 );

			SetHits( 7000, 8000 );
			SetStam( 503, 650 );
			SetDamage( 28, 55 );
			
			Fame = 22500;
			Karma = -22500;

			VirtualArmor = 60;

// 			if ( null != spec && null != spec.Skills )
// 			{
// 				for ( int i = 0;  i < spec.Skills.Length; i++ )
// 				{
// 					SetSkill( spec.Skills[ i ], (double)(spec.MaxSkillValues[ i ]) * 1.10, (double)(spec.MaxSkillValues[ i ]) * 1.50 );
// 				}
// 			}
			this.Tamable = false;	// Not appropriate as a pet
			Title = "";
			
			if ( null != spec && spec.GuardianEggOrDeedChance > Utility.RandomDouble() )
			{
				BaseEvoEgg egg = GetEvoEgg();

				if ( null != egg )
					PackItem( egg );
			}
		}

		protected override void PackSpecialItem() { }
		public override HideType HideType{ get{ return HideType.Dragon; } }
		public override int Hides{ get{ return 15; } }
		public override int Meat{ get{ return 19; } }

		public override void GenerateLoot()
		{
			AddLoot( LootPack.UltraRich, 4 );
			AddLoot( LootPack.FilthyRich );
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write( (int)0 );			
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();
		}
	}
}